#!/usr/local/bin/perl -w
# Prueba OpenURL a bases de datos de libros en Aleph

#use CGI qw/:standard/;
use CGI;
use DBI;

#Datos de la BD en PostgreSQL
$bd="multibase";
$tabla="multibase";
$user="apache";
$pass="apache";

$campostabla ='id,siglas,url,indice_titulo,indice_tema,indice_autor,indice_todo,software,institucion';

## DEFINICION DE VARIABLES FIJAS
$palabra='mexico';
$campo='Ttulo';
#$adj="Y";
$file='nacional.txt';
@arreglo='';
$arreglo2='';
$i=0;

$conn = DBI->connect("dbi:Pg:dbname=$bd",$user,$pass);

if (!$conn)
{  
   #Envia mensaje si no hay conexin a la BD
   print "No hay conexin\n";
}
else   #Si existe conexin a la BD 
{
   print "Consultando BD....\n";

    ## ABRIR ARCHIVO
    open(ARCHIVO,">$file");


     # Convierte la cadena en un arreglo
     @arreglo = split (" ", $arreglo2);
     $tamarreglo=@arreglo;

       # Crea la condicion con cada zona geogrfica seleccionada
       for $x (0 .. $tamarreglo-1)
       {        
          $condicion = $condicion." t.id_region=".$arreglo[$x]."";
          if ($x < $tamarreglo-1)
          { $condicion = $condicion." OR "; } 
       }
       if ($tamarreglo == 0)
       {  $condicion = " url <> '' ";  }
       else
       {  $condicion = "($condicion) AND url <> '' "; }

       $consulta="select $campostabla from $tabla where ($condicion) order by siglas";

       $sqlconsulta = $conn->prepare($consulta);
       $sqlconsulta->execute;
       $ary1=$sqlconsulta->fetchall_arrayref;
       $tary1=$sqlconsulta->rows;
       $conn->disconnect;

print "REG=$tary1";
       if ($tary1>0)
       {
          enlaces();
       }

       ##CIERRA EL ARCHIVO
       close(ARCHIVO);
}



### Procedimientos

    ## Crea enlaces a las bibliotecas
    sub enlaces()
    { 
       $termino=$palabra;
       $termino=~ tr/ /+/;
       $i=0;
       #Valida cada biblioteca recuperada en la busqueda
       while ($i <= $tary1-1)
       {
             $id = "$ary1->[$i]->[0]";
             $institucion="$ary1->[$i]->[8]";
             $software="$ary1->[$i]->[7]";
             $url="$ary1->[$i]->[2]";
             $siglas="$ary1->[$i]->[1]";

             creaurl($id); 
             $i++;

             # IMPRIME ENLACE AL ARCHIVO
             print ARCHIVO "$siglas\t$urlbases\n";

       }         
   }

   ## Genera el url pasando los parametros de termino e indice
   sub creaurl()
   {
       $indice="";
       $urlbases="";
       # Identifica el campo de busqueda
       if ($campo eq 'Ttulo')
       {
          $indice=$ary1->[$i]->[3];
       }
       if ($campo eq 'Tema')
       {
          $indice=$ary1->[$i]->[4];
       }
       if ($campo eq 'Autor')
       {
          $indice=$ary1->[$i]->[5];
       }
       if ($campo eq 'Todos los campos')
       {
          $indice=$ary1->[$i]->[6];
       }

       $termino =~ tr//a/;
       $termino =~ tr//e/;
       $termino =~ tr//i/;
       $termino =~ tr//o/;
       $termino =~ tr//u/;
       $termino =~ tr//u/;
       $termino =~ tr//a/;
       $termino =~ tr//e/;
       $termino =~ tr//i/;
       $termino =~ tr//o/;
       $termino =~ tr//u/;
       $termino =~ tr//u/;
       $car_ntilde = "%C3%B1";
       $termino =~ s//$car_ntilde/g; 
       $termino =~ s//$car_ntilde/g;

       if ($software =~ /Aleph 500/) ## Bibliotecas ALEPH 500 
       {
          $urlbases="$url&request=".$termino."&find_code=".$indice."&adjacent=N"; 
          if ($siglas =~ /UA/)
          { 
             $urlbases .="&filter_code_1=WLN&filter_code_2=WYR&filter_code_3=WYR&filter_code_4=WFM&filter_request_4=BK&filter_code_5=WSL";
          }
       }
       if ($software =~ /Horizon-Dynix/)  ## Bibliotecas Horizon-Dynix 
       {
          $urlbases=$url."&index=".$indice."&term=".$termino;
       }
       if ($software =~ /Horizonte/) ## Horizonte v.5.3
       {
          $urlbases="$url?pt=welcome&ts=template%5Fcide&mc=spa&bc=CIDE&lb=licide&sd=ipcide&bd=ipcide&cs=928020889&ls=1&db=ipcide&se=%2E".$indice.$termino."&de=".$termino."&sn=0&tm=sum";
       }
       if ($software =~ /INNOPAC/) ##  Innopac-Millenium
       { 
          $urlbases="$url".$indice."(".$termino.")";
       }
       if ($software =~ /Siabuc Siglo/) ##  Siabuc Siglo XXI 
       {
          $urlbases=$url."&$indice=$termino";
       }
       if ($software =~ /Siabuc 8/) ##  Siabuc 8
       {
          $urlbases=$url."?FormatoFicha=0&Cantidad=20&ACERVO=LIBROS&FichaINI=1&ArchivoCFG=Lib_Gral.cfg&$indice=$termino";
          if ($institucion =~ /Sinaloa/)
          {
             $urlbases=$url."?FormatoFicha=1&Cantidad=10&ACERVO=LIBROS&FichaINI=1&ArchivoCFG=abLib_Gral.CFG&mostrarFICHABIB=1&BUSQ_AVANZADA=1&BaseDTA=1&$indice=$termino";
          } 
          if ($siglas =~ /CICESE/)
          {
             $urlbases=$url."?FormatoFicha=0&Cantidad=10&ACERVO=LIBROS&FichaINI=1&ArchivoCFG=mono.cfg&mostrarFICHABIB=1&BUSQ_AVANZADA=1&BaseDTA=1&$indice=$termino";
          }
          if ($siglas =~ /CMQ/) ## Siabuc 8 act. 4.0
          {
             $urlbases=$url."?FormatoFicha=0&Cantidad=10&ACERVO=LIBROS&FichaINI=1&ArchivoCFG=BDL_Gral.CFG&opCampo1=".$indice."&txtEXPR1=".$termino."&BUSQ_AVANZADA=1&mostrarFICHABDL=1";
             $termino=~ tr/+/ /;
          }
          if ($siglas =~ /UCOL/) ##Univ. Colima
          {
             $urlbases=$url."?FormatoFicha=1&Cantidad=10&ACERVO=LIBROS&FichaINI=1&ArchivoCFG=abLib_Mult.CFG&mostrarFICHABIB=1&BUSQ_AVANZADA=1&BaseDTA=99&txtEXPR1=$termino&opCAMPO1=$indice";
          }

       }
       if ($software =~ /Alexandria/) ## Alexandria 5.11
       {
          if ($siglas =~ /FLACSO/)
          {
             $urlbases="$url/boolean/results/?collection=309&S0=".$indice."&SearchField0=".$termino."&O0=And&S1=Keyword&SearchField1=&B2=Search&B3=Expert";
          }
          else ## UAEH
          {
             # primero obtiene numero de sesion
             $url0="http://dbci.uaeh.edu.mx:81";
             $HTML = LWP::UserAgent->new;
             $response = $HTML->get( $url0 );
             $HTML= $response->as_string;
             @lineas = split (/\n/,$HTML);
             foreach $linea (@lineas){
                if( $linea =~ /sessionid=/){
                    @texto1 = split (/sessionid=/,$linea);
                    @texto2 = split (/">/,$texto1[1]);
                    $sesionid = $texto2[0];
                }
             }
             $urlbases="$url/boolean/results/?collection=1&S0=$indice&SearchField0=$termino&O0=And&S1=Keyword&SearchField1=&B2=Search&B3=Expert&sessionid=$sesionid";
          }
       }
       if ($software =~ /Innovative/) ##  Innovative-Millenium
       {
          if ($id == 5)
          { $urlbases="$url".$indice."?SEARCH=".$termino."&SORT=D&searchscope=5"; }
          if ($id == 38)
          { $urlbases="$url".$indice."?SEARCH=".$termino."&SORT=D&searchscope=18"; }
       }
       if ($software =~ /IMCED/) ## Propio o desconocido 
       {
          $urlbases="$url&".$indice."=1&user_query=".$termino;
       }
       if ($software =~ /Acervo/) ## Acervo v.2007
       {
          $urlbases=$url."&$indice=$termino";
       }
       if ($software =~ /CIO/) ## Propio
       {
          $urlbases=$url."?tipo1=".$indice."&patron=".$termino;
       }
       if ($software =~ /INECOL/) ## Propio
       {
          $urlbases=$url."?sql=".$indice."+LIKE+'*".$termino."*'";
       }
       if ($software =~ /CIMAT/) ## Propio
       {
          $urlbases=$url."?cad=$termino&campo=$indice";
       }
       if ($software =~ /Altair/) ## Altair v.1.8
       {
          $urlbases=$url."&qry=$indice=($termino)&txtTema=$termino&cboTag=*$indice*";
       }
       if ($software =~ /USON/) ## Propio
       {
          $urlbases=$url."&crit1=$indice&busq1=$termino";
       }
       if ($software =~ /UJAT/) ## Propio
       {
          $urlbases="$url?Consulta=1&opcion1=LB&nombre1=$termino&opcion=$indice";
       }
       if ($software =~ /Sirsi/) ## SirsiDynix Webcat 
       {
          $urlbases="$url?searchdata1=$termino&words+or+phrase&searcgoper1=AND&srchfield1=$indice&sort_by=-PBYR&user_id=WEBSERVER&password=&submit=Search";
       }

      return($urlbases);
   }

exit;


